/**
 * \file: mlink_wfd_touch.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MLINK WiFi-Display Touch Adapter
 *
 * \component: mlink
 *
 * \author: V.Deety / RBEI/ECF3 / venkatasaiganesh.deety@in.bosch.com
 *
 * \copyright (c) 2016 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#include "mlink_wfd_touch.h"
#include "mlink_wfd_touch_internals.h"

void mlink_wfd_touch_init(VNCWiFiDisplaySDK* pWFDSDK, VNCWiFiDisplaySink* pWFDSink, void* SessionCtx)
{
    WfdTouch* pWfdTouch = WfdTouch::getInstance();
    if (pWfdTouch)
    {
        pWfdTouch->initialize(pWFDSDK, pWFDSink, SessionCtx);
    }
}

void mlink_wfd_touch_deinit()
{
    WfdTouch* pWfdTouch = WfdTouch::getInstance();
    if (pWfdTouch)
    {
        pWfdTouch->shutdown();
        pWfdTouch->deleteInstance();
    }
}
